

/*
*  DISCLAIMER:
*
*      THIS SOFTWARE, SOURCE CODE AND ASSOCIATED MATERIALS INCLUDING BUT NOT LIMITED TO TUTORIALS,
*      GUIDES AND COMMENTARY PROVIDED WITH THIS EXERCISE ARE ONLY DESIGNED FOR REFERENCE PURPOSES
*      TO GIVE AN EXAMPLE TO LICENSEE FOR THEIR OWN NECESSARY DEVELOPMENT OF THEIR OWN SOFTWARE AND/OR
*      APPLICATION. IT IS NOT DESIGNED FOR ANY SPECIAL PURPOSE, SERIAL PRODUCTION OR USE IN MEDICAL,
*      MILITARY, AIR CRAFT, AVIATION, SPACE OF LIFE SUPPORT EQUIPMENT.
*
*      TO THE EXTENT PERMITTED BY LAW, THE EXERCISE SOFTWARE AND/OR SOURCE CODE AND/OR AND ASSOCIATED
*      MATERIALS IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND AND ONLY FOR REFERENCE PURPOSES.
*
*      SYNAPTIC LABORATORIES LTD. MAKES NO WARRANTIES, EITHER EXPRESS OR IMPLIED, WITH RESPECT TO THE
*      LICENSED SOFTWARE AND/OR SOURCE CODE AND/OR ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND
*      DOCUMENTATION PROVIDED HEREUNDER. 
*
*      SYNAPTIC LABORATORIES LTD. SPECIFICALLY DISCLAIMS THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
*      FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT OF ANY INTELLECTUAL
*      PROPERTY RIGHT OF ANY THIRD PARTY WITH REGARD TO THE SOFTWARE, DOCUMENTATION (SCHEMATICS ETC.),
*      SOURCE CODE AND ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND DOCUMENTATION.
*
*      ANY USE, COMPILATION AND TESTING OF THE SOFTWARE AND/OR SOURCE CODE IS AT LICENSEE`S OWN RISK
*      AND LICENSEE IS OBLIGED TO CONDUCT EXTENSIVE TESTS TO AVOID ANY ERRORS AND FAILURE IN THE
*      COMPILED SOURCE CODE, DOCUMENTATION (SCHEMATICS ETC.) AND THE HEREFROM GENERATED SOFTWARE
*      OF LICENSEE.
*
*      EXCEPT FOR WILFULL INTENT SYNAPTIC LABORATORIES LTD. SHALL IN NO EVENT BE ENTITLED TO OR LIABLE
*      FOR ANY INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND OR NATURE, INCLUDING,
*      WITHOUT LIMITATION, BUSINESS INTERRUPTION COSTS, LOSS OF PROFIT OR REVENUE, LOSS OF DATA,
*      PROMOTIONAL OR MANUFACTURING EXPENSES, OVERHEAD, COSTS OR EXPENSES ASSOCIATED WITH WARRANTY
*      OR INTELLECTUAL PROPERTY INFRINGEMENT CLAIMS, INJURY TO REPUTATION OR LOSS OF CUSTOMERS.
*
*/


#include <stdio.h>
#include <string.h>
#include "sys/alt_cache.h"
#include "sll_psram_tests.h"

//--------------------------------------------------------------------------------------------------------------------------
// Test bits 0 through 31 to make sure the data path bus connections are all working
//
int sll_psram_tests_single_data_bit_test(uint32_t base, int use_printf )
{
	int errors = 0;
    uint32_t i;
    uint32_t readback;

    if( use_printf ){ lld_printf("Test: Sliding single data bit test within 32-bit word at Address: 0x%08lX\r\n", base); }

    for (i = 0; i <= 31; i++)
    {
      uint32_t test_value = 1 << i;

      // Test bits 0 through 31 to make sure the data path bus connections are all working
      IOWR_32(base, 0, test_value);
      readback = IORD_32(base, 0);

      if (readback != test_value){
    	  if( use_printf ){ lld_printf("  - ERROR: Value should be 0x%08lXU but is 0x%08lX\r\n", test_value, readback); }
        errors++;
      }
   }

  if (!errors){
	  if( use_printf ){ lld_printf("  - PASS\r\n\n"); }
  }
  return (errors);
}

static int psram_tests_byte_check_report_08bits( unsigned char target, unsigned char value, int errors, int use_printf ){
	if(value != target){
		if( use_printf ){ lld_printf("FAIL: should be 0x%02X but is 0x%02X\r\n", target, value); }
		return errors+1;
	}else{
		if( use_printf ){ lld_printf("PASS\r\n"); }
		return errors;
	}
}

static int psram_tests_byte_check_report_16bits( unsigned short target, unsigned short value, int errors, int use_printf ){
	if(value != target){
		if( use_printf ){ lld_printf("FAIL: should be 0x%04X but is 0x%04X\r\n", target, value); }
		return errors+1;
	}else{
		if( use_printf ){ lld_printf("PASS\r\n"); }
		return errors;
	}
}

static int psram_tests_byte_check_report_32bits( unsigned int target, unsigned int value, int errors, int use_printf ){
	if(value != target){
		if( use_printf ){ lld_printf("FAIL: should be 0x%08X but is 0x%08X\r\n", target, value); }
		return errors+1;
	}else{
		if( use_printf ){ lld_printf("PASS\r\n"); }
		return errors;
	}
}


//--------------------------------------------------------------------------------------------------------------------------
// Test the Byte Enable logic on the target memory
//
int sll_psram_tests_byte_enable_test(uint32_t base, int use_printf )
{
  uint32_t  	d32;
  unsigned short 	d16;
  unsigned char  	d08;
  int 			 	errors = 0;
//  volatile uint32_t*	sdram = (uint32_t*)base;

  if( use_printf ){ lld_printf("Test: PSRAM 8/16 bit Byte Enable Test at address: 0x%08lX\r\n", base); }

//  lld_printf( " = Flush all data cache\r\n");
  alt_dcache_flush_all();

//  lld_printf( " = Invalidate word\r\n");
  IOWR_32(base, 0, 0xdeadbeef);

//  lld_printf( " = Flush all data cache\r\n");
  alt_dcache_flush_all();


  /////////////////////////////////////////////////////////////////////

  if( use_printf ){  lld_printf(" = 4x08-bit Write:\r\n"); }
  IOWR_8(base, 0, 0x0A);		//  sdram[0] = 0x0A;
  IOWR_8(base, 1, 0x05);		//	sdram[1] = 0x05;
  IOWR_8(base, 2, 0xA0);		//	sdram[2] = 0xA0;
  IOWR_8(base, 3, 0x50);		//	sdram[3] = 0x50;

//  lld_printf( "   - Flush all data cache\r\n");
  alt_dcache_flush_all();

  if( use_printf ){ lld_printf("   - 32-bit Read [0]:  " );}
  d32 = IORD_32( base, 0 );  	//  d = sdram[0];
  errors = psram_tests_byte_check_report_32bits( 0x50A0050A, d32, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 16-bit Read [0]:  "); }
  d16 = IORD_16( base, 0 );	//  d16 = sdram16[0];
  errors = psram_tests_byte_check_report_16bits( 0x050a, d16, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 16-bit Read [1]:  "); }
  d16 = IORD_16( base, 2 );	//  d16 = sdram16[1];
  errors = psram_tests_byte_check_report_16bits( 0x50A0, d16, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [0]:  "); }
  d08 = IORD_8( base,  0 );  	//  d = sdram[0];
  errors = psram_tests_byte_check_report_08bits( 0x0A, d08, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [1]:  "); }
  d08 = IORD_8( base,  1 );  	//  d = sdram[1];
  errors = psram_tests_byte_check_report_08bits( 0x05, d08, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [2]:  "); }
  d08 = IORD_8( base,  2 );  	//  d = sdram[2];
  errors = psram_tests_byte_check_report_08bits( 0xA0, d08, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [3]:  "); }
  d08 = IORD_8( base,  3 );  	//  d = sdram[3];
  errors = psram_tests_byte_check_report_08bits( 0x50, d08, errors, use_printf  );


  /////////////////////////////////////////////////////////////////////

//  lld_printf(" = Invalidate word\r\n");
  IOWR_32(base, 0, 0xdeadbeef);

//  lld_printf( " = Flush all data cache\r\n");
  alt_dcache_flush_all();

  if( use_printf ){ lld_printf(" = 2x16-bit Write:\r\n"); }
  IOWR_16(base, 0, 0x050a);		//  sdram16[0] = 0x050a;
  IOWR_16(base, 2, 0x50a0);		//	sdram16[1] = 0x50a0;

//  lld_printf( "   - Flush all data cache\r\n");
  alt_dcache_flush_all();

  if( use_printf ){ lld_printf("   - 32-bit Read [0]:  " ); }
  d32 =  IORD_32( base, 0 );  	//  d = sdram[0];
  errors = psram_tests_byte_check_report_32bits( 0x50A0050A, d32, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 16-bit Read [0]:  "); }
  d16 = IORD_16( base, 0 );	//  d16 = sdram16[0];
  errors = psram_tests_byte_check_report_16bits( 0x050a, d16, errors, use_printf  );

  if( use_printf ){  lld_printf("   - 16-bit Read [1]:  "); }
  d16 = IORD_16( base, 2 );	//  d16 = sdram16[1];
  errors = psram_tests_byte_check_report_16bits( 0x50A0, d16, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [0]:  "); }
  d08 = IORD_8( base,  0 );  	//  d = sdram[0];
  errors = psram_tests_byte_check_report_08bits( 0x0A, d08, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [1]:  "); }
  d08 = IORD_8( base,  1 );  	//  d = sdram[1];
  errors = psram_tests_byte_check_report_08bits( 0x05, d08, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [2]:  "); }
  d08 = IORD_8( base,  2 );  	//  d = sdram[2];
  errors = psram_tests_byte_check_report_08bits( 0xA0, d08, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [3]:  "); }
  d08 = IORD_8( base,  3 );  	//  d = sdram[3];
  errors = psram_tests_byte_check_report_08bits( 0x50, d08, errors, use_printf  );


  /////////////////////////////////////////////////////////////////////

//  lld_printf(" = Invalidate word\r\n");
  IOWR_32(base, 0, 0xdeadbeef);

//  lld_printf( " = Flush all data cache\r\n");
  alt_dcache_flush_all();

  if( use_printf ){ lld_printf(" = 1x32-bit Write:\r\n"); }
  IOWR_32(base, 0, 0x50a0050a);		//  sdram32[0] = 0x50a0050a;

//  lld_printf( "   - Flush all data cache\r\n");
  alt_dcache_flush_all();

  if( use_printf ){ lld_printf("   - 32-bit Read [0]:  " ); }
  d32 =  IORD_32( base, 0 );  	//  d = sdram[0];
  errors = psram_tests_byte_check_report_32bits( 0x50A0050A, d32, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 16-bit Read [0]:  "); }
  d16 = IORD_16( base, 0 );	//  d16 = sdram16[0];
  errors = psram_tests_byte_check_report_16bits( 0x050a, d16, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 16-bit Read [1]:  "); }
  d16 =  IORD_16( base, 2 );	//  d16 = sdram16[1];
  errors = psram_tests_byte_check_report_16bits( 0x50A0, d16, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [0]:  "); }
  d08 = IORD_8( base,  0 );  	//  d = sdram[0];
  errors = psram_tests_byte_check_report_08bits( 0x0A, d08, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [1]:  "); }
  d08 = IORD_8( base,  1 );  	//  d = sdram[1];
  errors = psram_tests_byte_check_report_08bits( 0x05, d08, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [2]:  "); }
  d08 = IORD_8( base,  2 );  	//  d = sdram[2];
  errors = psram_tests_byte_check_report_08bits( 0xA0, d08, errors, use_printf  );

  if( use_printf ){ lld_printf("   - 08-bit Read [3]:  "); }
  d08 = IORD_8( base,  3 );  	//  d = sdram[3];
  errors = psram_tests_byte_check_report_08bits( 0x50, d08, errors, use_printf  );


  if (!errors){
	  if( use_printf ){ lld_printf("\r\n = All Byte Enabled Tests Passed\r\n\n"); }
  }
  return (errors);
}


//--------------------------------------------------------------------------------------------------------------------------
//
// This tests that values can be assigned to EVERY address in the SDRAM address space
//

//int memTestAddressBus(volatile u32 * baseAddress, uint32_t nBytes);

int sll_psram_tests_read_write_span_accessibility_test(uint32_t base, uint32_t span, int use_printf )
{
	int errors = 0;
    uint32_t readback;
    uint32_t *sdram = (uint32_t*) (base);
    uint32_t index;

    if( use_printf ){ lld_printf("Test: Read and Write to each 32-bit word in range 0x%08lX to 0x%08lX \r\n", base, (base+span)); }


 //   lld_printf("  - Invalidate contents of memory region using memset\r\n");
    memset( sdram, 0xDEADBEEF, span );

//    lld_printf("  - Flush all of L1 data cache\r\n");
     alt_dcache_flush_all();

    if( use_printf ){  lld_printf("  - Writing value of index into each 32-bit word of span using IOWR operations\r\n"); }
    for (index = 0; index < (span / 4); index++) {
    	IOWR_32(base, index * 4, index);
    }

//    lld_printf("  - Flush all of L1 data cache\r\n");
     alt_dcache_flush_all();

    if( use_printf ){ lld_printf("  - Reading value of index from each 32-bit word of span using IORD operations\r\n"); }
    for (index = 0; index < (span / 4); index++) {
      //check that the value at the current SDRAM address is what we assigned it to
      readback = IORD_32(base, (index * 4));
      if (readback != index){
    	  if( use_printf ){ lld_printf("    - ERROR    Value should be 0x%08lX but is 0x%08lX at 0x%08lX\r\n", index, readback, index*4); }
        errors++;
      }
    }
    if ( errors == 0 ){
    	if( use_printf ){ lld_printf("    - PASS verification test\r\n"); }
    }else{
    	if( use_printf ){ lld_printf("    - FAIL with %d errors\r\n", errors); }
    }

    errors = 0;
            

//    lld_printf("  - Invalidate contents of memory region using memset\n");
    memset( sdram, 0xDEADBEEF, span );

//    lld_printf("  - Flush all of L1 data cache\n");
    alt_dcache_flush_all();

    if( use_printf ){ lld_printf("  - Writing value of index into each 32-bit word of span using (cacheable) WR operations\r\n"); }
    for (index = 0; index < (span / 4); index++){
    	sdram[index] = index;
    }

//    lld_printf("  - Flush all of L1 data cache\n");
    alt_dcache_flush_all();

    if( use_printf ){ lld_printf("  - Reading value of index from each 32-bit word of span using (cacheable) RD operations\r\n"); }
    for (index = 0; index < (span /4); index++)    {
      //check that the value at the current SDRAM address is what we assigned it to
      readback = sdram[index];
      if (readback != index){
    	  if( use_printf ){ lld_printf("    - ERROR    Value should be 0x%08lX but is 0x%08lX at 0x%08lx\r\n", index, readback, index*4); }
        errors++;
     }
    }
    if( use_printf ){
    if ( errors == 0 ){
    	lld_printf("    - PASS verification test\r\n");
    }else{
    	lld_printf("    - FAIL with %d errors\r\n", errors);
    }
    }
    

    return errors;
}

//--------------------------------------------------------------------------------------------------------------------------
//
// This runs all tests
//


int sll_psram_tests_all(uint32_t base, uint32_t amount, uint32_t skip, int num_of_passes,  int use_printf)
{
	 int      pass;
	 int      psram_error = 0;
	 
  for (pass=0; pass < num_of_passes; pass++)
	{

		lld_printf("PSRAM Test : Running pass %lu of %lu passes \r\n", pass + 1, num_of_passes);

		// Check the data path
		psram_error = psram_error + sll_psram_tests_single_data_bit_test(base, 1);

		// Check the byte enable logic
		psram_error = psram_error + sll_psram_tests_byte_enable_test(base, 1);

		// Do various other tests and measure the execution time.
		psram_error = psram_error + sll_psram_tests_read_write_span_accessibility_test(base, amount, 1);

		lld_printf("PSRAM Test  :Pass Number: %4lu,  Errors: %4lu \r\n", pass, psram_error);
	}
	return psram_error;
}

